﻿using System;

namespace Percent___Qualification_work.Classes
{
    public class Game
    {
        public int? Id { get; set; }            // Nullable ID of the game (optional when adding a new game)
        public string Name { get; set; }        // Name of the game
        public string Genre { get; set; }       // Genre of the game
        public string Developer { get; set; }   // Developer of the game
        public int ReleaseYear { get; set; }    // Release year of the game
        public byte[] CoverImage { get; set; }  // BLOB for cover image of the game

        // Constructor with optional Id (for adding new games)
        public Game(int? id, string name, string genre, string developer, int releaseYear, byte[] coverImage)
        {
            Id = id;
            Name = name;
            Genre = genre;
            Developer = developer;
            ReleaseYear = releaseYear;
            CoverImage = coverImage;
        }

        // Override ToString to display relevant game information
        public override string ToString()
        {
            return $"Is this the game you want to add?\n" +
                   $"Name: {Name}\n" +
                   $"Genre: {Genre}\n" +
                   $"Developer: {Developer}\n" +
                   $"Release Year: {ReleaseYear}";
        }
    }
}